### 功能块

#### **FB\_CTRL\_TempController**

![](https://resource.helplook.net/docker_production/3648ne/article/fHHjv4By/680efa7804e97.png)


温度控制器功能块 **FB\_CTRL\_TempController** 具有多个输入和输出，具体描述如下。所有控制器的参数均通过结构体传递给功能块。

**接口**

**VAR\_INPUT**

| 名称                      | **类型**                     | 初始化 | 描述                          |
| ----------------------- | -------------------------- | --- | --------------------------- |
| eCtrlMode               | ControlToolBox.E\_CtrlMode |     | 操作模式: passive, activ, check |
| bSelSetpoint            | BOOL                       |     | FALSE = fW1, TRUE = fW2     |
| fW1                     | LREAL                      |     | 设定点                         |
| fW2                     | LREAL                      |     | 备选设定点，一般低于fW1               |
| fX                      | LREAL                      |     | 实际值                         |
| fYManual                | LREAL                      |     | 手动模式下的控制值                   |
| bOpenThermocouple       | BOOL                       |     | TRUE: 热电偶断线，硬件反馈信号          |
| bReverseThermocouple    | BOOL                       |     | TRUE: 热电偶接线错误               |
| bBackVoltage            | BOOL                       |     | TRUE: 热电偶接线错误               |
| bLeakage                | BOOL                       |     | TRUE: 加热单元检测到漏电流，硬件反馈信号     |
| bShortCircuit           | BOOL                       |     | TRUE: 加热单元检测到短路，硬件反馈信号      |
| bOpenCircuit            | BOOL                       |     | TRUE: 加热单元检测到断路，硬件反馈信号      |
| sParaControllerExternal | ST\_CTRL\_ParaController   |     | 外部控制器参数                     |



**VAR\_IN\_OUT**

| **名称**               | **类型**                      | 初始化 | 描述          |
| -------------------- | --------------------------- | --- | ----------- |
| sControllerParameter | ST\_CTRL\_TempCtrlParameter |     | 一般参数（采样时间等） |



**VAR\_OUTPUT**

| **名称**                  | **类型**                          | 初始化                                            | 描述              |
| ----------------------- | ------------------------------- | ---------------------------------------------- | --------------- |
| fYAnalog                | LREAL                           |                                                | 模拟控制值           |
| bYPWMPos                | BOOL                            |                                                | 脉宽调制，加热模式       |
| bYPWMNeg                | BOOL                            |                                                | 脉宽调制，冷却模式       |
| bYDigPos                | BOOL                            |                                                | 三点式：数字控制值，正向    |
| bYDigNeg                | BOOL                            |                                                | 三点式：数字控制值，负向    |
| dwAlarm                 | DWORD                           |                                                | 最多可以监控32个独立报警状态 |
| fMaxOverShoot           | LREAL                           |                                                | 最大超调量，反映控制质量    |
| tStartUpTime            | TIME                            |                                                | 启动时间            |
| eCtrlState              | ControlToolBox.E\_CtrlState     | ControlToolBox.E\_CtrlState.eCTRL\_STATE\_IDLE | 控制器状态           |
| sParaControllerInternal | ST\_CTRL\_ParaController        |                                                | 内部控制器参数集        |
| bError                  | BOOL                            |                                                | 错误状态            |
| eErrorId                | ControlToolBox.E\_CtrlErrorCode |                                                | 错误标识码           |
| fYP                     | LREAL                           | 0.0                                            | 比例环节控制值         |
| fYI                     | LREAL                           | 0.0                                            | 积分环节控制值         |
| fYD                     | LREAL                           | 0.0                                            | 微分环节控制值         |
| fTempVelo               | LREAL                           |                                                | 温度变化速率          |

**使用要求**

| 开发环境        | 目标平台 | 需要包含的**PLC 库**  |
| ----------- | ---- | --------------- |
| MetaFacture | PC   | ZKSDTempControl |

#### **结构体定义**

**&#x20;ST\_CTRL\_TempCtrlParameter**

| **名称**                    | **类型**                                | 初始化         | 描述                              |
| ------------------------- | ------------------------------------- | ----------- | ------------------------------- |
| iMode                     | E\_CTRL\_ControlMode                  |             | 1=加热模式, 2=冷却模式, 3=加热和冷却模式       |
| iReactionOnFailure        | E\_CTRL\_ReactionOnFailure            |             | 0=控制器关闭, 1=手动操作, 2=yMin, 3=yMax |
| bSelCtrlParameterSet      | BOOL                                  |             | FALSE = 内部参数, TRUE = 外部参数       |
| dwAlarmSupp               | DWORD                                 |             | 警报抑制                            |
| tCtrlCycleTime            | TIME                                  |             | 控制器采样时间                         |
| tTaskCycleTime            | TIME                                  |             | plc任务周期                         |
| iTuningMode               | E\_CTRL\_TuneMode                     |             | 仅加热、仅冷却、先加热后冷却或相反               |
| tTuneStabilisation        | TIME                                  | TIME#20s0ms | 等待系统稳定                          |
| fEndTunePercentHeating    | LREAL                                 | 80.0        | 当 X > 0.8\*W 时，切换到闭环控制          |
| fYTuneHeating             | LREAL                                 |             | 调整过程中施加阶跃信号                     |
| fYStableHeating           | LREAL                                 |             | 调整操作                            |
| fEndTunePercentCooling    | LREAL                                 | 20.0        | 当 X < 0.2\*W 时，切换到闭环控制          |
| fYTuneCooling             | LREAL                                 |             | 调整过程中施加阶跃信号                     |
| fYStableCooling           | LREAL                                 |             | 调整操作                            |
| fScalingFactor            | LREAL                                 | 1.0         | KP 加热/冷却的比例系数缩放因子               |
| fWMin                     | LREAL                                 |             | 设定值下限                           |
| fWMax                     | LREAL                                 |             | 设定值上限                           |
| bEnableSoftStart          | BOOL                                  |             | FALSE = 无软启动, TRUE = 软启动        |
| bEnableRamping            | BOOL                                  |             | FALSE = 无斜坡调整, TRUE = 斜坡调整      |
| fWStartUp                 | LREAL                                 |             | 软启动平台设定值                        |
| tStartUp                  | TIME                                  |             | 软启动等待时间                         |
| bStartUpRamping           | BOOL                                  |             | 在启动阶段启用斜坡调整                     |
| fWStartUpVeloPos          | LREAL                                 |             | 启动阶段设定值增加的最大斜率                  |
| fWStartUpVeloNeg          | LREAL                                 |             | 启动阶段设定值减少的最大斜率                  |
| fWVeloPos                 | LREAL                                 |             | 设定值增加的最大斜率                      |
| fWVeloNeg                 | LREAL                                 |             | 设定值减少的最大斜率                      |
| bFilter                   | BOOL                                  |             | 启用滤波器                           |
| tFilter                   | TIME                                  |             | 实际值滤波器的时间常数                     |
| bDeadband                 | BOOL                                  |             | 死区参数                            |
| fEDeadband                | LREAL                                 |             | 死区正值（K）                         |
| bDeadbandOnInput          | BOOL                                  |             | 默认情况下，死区作用于输入；如果为FALSE，死区作用于输出  |
| bMinimizeOvershoot        | BOOL                                  |             | 超调最小化参数                         |
| fEDelta                   | LREAL                                 |             | 最小化控制误差                         |
| fYMinimizeOvershoot       | LREAL                                 |             | 最小化超调量                          |
| fYMin                     | LREAL                                 |             | 控制值下限                           |
| fYMax                     | LREAL                                 |             | 控制值上限                           |
| fYManual                  | LREAL                                 |             | 手动操作控制值                         |
| fYOnFailure               | LREAL                                 |             | 故障时控制值                          |
| bPWMCool                  | BOOL                                  | FALSE       | 启用特殊冷却PWM                       |
| tPWMCycleTime             | TIME                                  |             | PWM 周期                          |
| tPWMMinOffTime            | TIME                                  |             | PWM 最小关断时间                      |
| tPWMMinOnTime             | TIME                                  |             | PWM 最小开启时间                      |
| tPWMWaitingTime           | TIME                                  |             | not yet implemented !!!!        |
| tPWMCycleTimeCool         | TIME                                  |             | 冷却设备PWM 周期                      |
| tPWMMinOffTimeCool        | TIME                                  |             | 冷却设备PWM 最小关断时间                  |
| tPWMMinOnTimeCool         | TIME                                  |             | 冷却设备PWM 最小开启时间                  |
| tPWMWaitingTimeCool       | TIME                                  |             | not yet implemented !!!!        |
| fYThresholdOff            | LREAL                                 |             | 三点式：关闭阈值                        |
| fYThresholdOn             | LREAL                                 |             | 三点式：开启阈值                        |
| nCyclesForSwitchOver      | INT                                   | 100         | 切换参数集周期数                        |
| bEnablePreController      | BOOL                                  |             | 启用前馈控制器                         |
| bEnableZones              | BOOL                                  |             | 启用开环控制直到接近设定值                   |
| fEnableZoneClosedLoopZone | LREAL                                 | 100.0       | 启用闭环控制设定值周围阈值                   |
| bEnableCVFilter           | BOOL                                  |             | 启用控制值滤波器（类型参见 iFilterType）      |
| iFilterType               | E\_CTRL\_FilterType                   |             | 控制值（CV）滤波器的滤波类型                 |
| iControllerType           | E\_CTRL\_ControllerType               |             | 常用控制器为PID控制器                    |
| bAlternateParameter       | BOOL                                  |             | 切换至备用参数集 — not yet supported    |
| nAlternateParameterSet    | ControlToolBox.E\_CtrlParameterRecord |             | 备用参数集数量 — not yet supported     |
| bPPartInFeedbackPath      | BOOL                                  |             | 比例反馈控制                          |
| bDPartInFeedbackPath      | BOOL                                  |             | 微分反馈控制                          |
| TempLow                   | LREAL                                 |             | 低温报警                            |
| TempLowLow                | LREAL                                 |             | 极低温报警                           |
| TempHigh                  | LREAL                                 |             | 高温报警                            |
| TempHighHigh              | LREAL                                 |             | 极高温报警                           |
| TempAbsoluteHigh          | LREAL                                 |             | 绝对高温上限                          |
| TempAbsoluteLow           | LREAL                                 |             | 绝对低温下限                          |
| fTuneKp                   | LREAL                                 | 1.2         | 比例增益调节参数                        |
| fTuneTn                   | LREAL                                 | 2.0         | 积分时间常数调节参数                      |
| fTuneTv                   | LREAL                                 | 0.42        | 前馈时间常数调节参数                      |
| fTuneTd                   | LREAL                                 | 0.25        | 微分时间常数调节参数                      |

**ST\_CTRL\_ParaController**

| **名称** | **类型**            | 初始化 | 描述          |
| ------ | ----------------- | --- | ----------- |
| KpHeat | LREAL             |     | 加热模式，比例增益参数 |
| TnHeat | TIME              |     | 加热模式，积分时间常数 |
| TvHeat | TIME              |     | 加热模式，前馈时间常数 |
| TdHeat | TIME              |     | 加热模式，微分时间常数 |
| KpCool | LREAL             |     | 冷却模式，比例增益参数 |
| TnCool | TIME              |     | 冷却模式，积分时间常数 |
| TIME   | E\_CTRL\_TuneMode |     | 冷却模式，前馈时间常数 |
| TdCool | TIME              |     | 冷却模式，微分时间常数 |

**ST\_CTRL\_RingBuffer&#x20;**

| **名称**        | **类型**                             |
| ------------- | ---------------------------------- |
| RingBuffer    | ARRAY \[0..RingBufferLen] OF LREAL |
| RingBufferPos | INT                                |

**ENUM:**

ERROR

| 名称        | 类型  |
| --------- | --- |
| NO\_ERROR | INT |
| TIME\_OUT | INT |

&#x20;E\_CTRL\_ControllerStateInternal&#x20;

| 名称                                      | 类型  | 初始化 |
| --------------------------------------- | --- | --- |
| E\_CTRL\_ControllerStateInternalHeating | INT | 1   |
| E\_CTRL\_ControllerStateInternalCooling | INT | 2   |

E\_CTRL\_ControllerType

| **名称**                          | **类型** | 初始化 | 描述          |
| ------------------------------- | ------ | --- | ----------- |
| eCTRL\_ControllerType\_PID      | INT    | 1   |             |
| eCTRL\_ControllerType\_PI       | INT    |     | no D-Part ! |
| eCTRL\_ControllerType\_PID\_Pre | INT    |     |             |
| eCTRL\_ControllerType\_PIDD2    | INT    |     |             |

E\_CTRL\_ControlMode

| **名称**                               | **类型** | 初始化 |
| ------------------------------------ | ------ | --- |
| eCTRL\_ControlMode\_HEATING          | INT    | 1   |
| eCTRL\_ControlMode\_COOLING          | INT    |     |
| eCTRL\_ControlMode\_HEATING\_COOLING | INT    |     |

E\_CTRL\_FilterType

| **名称**                        | **类型** | 初始化 |
| ----------------------------- | ------ | --- |
| eCTRL\_FilterType\_FIRSTORDER | INT    | 1   |
| eCTRL\_FilterType\_AVERAGE    | INT    |     |

E\_CTRL\_ReactionOnFailure

| **名称**                                   | **类型** | 初始化 |
| ---------------------------------------- | ------ | --- |
| eCTRL\_ReactionOnFailure\_NoFailure      | INT    | 0   |
| eCTRL\_ReactionOnFailure\_StopController | INT    |     |
| eCTRL\_ReactionOnFailure\_SetManMode     | INT    |     |
| eCTRL\_ReactionOnFailure\_SetYMax        | INT    |     |
| eCTRL\_ReactionOnFailure\_SetYMin        | INT    |     |
| eCTRL\_ReactionOnFailure\_SetYMean       | INT    |     |

E\_CTRL\_STATE\_TUNING

| **名称**                      | **类型** | 初始化 | 描述          |
| --------------------------- | ------ | --- | ----------- |
| eCTRL\_STATE\_TUNING\_INIT  | INT    | 0   | 初始化状态       |
| eCTRL\_STATE\_TUNING\_IDLE  | INT    | 1   | 空闲状态        |
| eCTRL\_STATE\_TUNING\_PULSE | INT    | 4   | 重启，脉冲激励状态   |
| eCTRL\_STATE\_TUNING\_STEP  | INT    | 5   | 手动操作，阶跃激励状态 |
| eCTRL\_STATE\_TUNING\_READY | INT    | 6   | 整定完成状态      |
| eCTRL\_STATE\_TUNING\_ERROR | INT    | 7   | 整定错误状态      |

&#x20;E\_CTRL\_TuneMode

| **名称**                            | **类型** | 初始化 | 描述             |
| --------------------------------- | ------ | --- | -------------- |
| eCTRL\_TuneMode\_HEATING          | INT    | 1   | 阶跃响应整定：仅加热     |
| eCTRL\_TuneMode\_COOLING          | INT    |     | 阶跃响应整定：仅冷却     |
| eCTRL\_TuneMode\_HEATING\_COOLING | INT    |     | 阶跃响应整定：先加热，再冷却 |
| eCTRL\_TuneMode\_COOLING\_HEATING | INT    |     | 阶跃响应整定：先冷却，再加热 |
| eCTRL\_TuneMode\_OSCILLATION      | INT    |     | 动态振荡整定         |

**报警位掩码**

| **名称**                    | **类型** | **初始化**              | **描述**  |
| ------------------------- | ------ | -------------------- | ------- |
| 硬件报警                      |        |                      |         |
| nAlarmOpenThermocouple    | DWORD  | 2#1                  | 热电偶开路警告 |
| nAlarmReverseThermocouple | DWORD  | 2#10                 | 热电偶反接警告 |
| nAlarmBackVoltage         | DWORD  | 2#100                | 反向电压警告  |
| nAlarmLeakageCurrent      | DWORD  | 2#1000               | 漏电流警告   |
| nAlarmShortCircuit        | DWORD  | 2#10000              | 短路警告    |
| nAlarmOpenCircuit         | DWORD  | 2#100000             | 断路警告    |
| 软件报警                      |        |                      |         |
| nAlarmLimitLow            | DWORD  | 2#100000000          | 低温警告    |
| nAlarmLimitLowLow         | DWORD  | 2#1000000000         | 极低温警告   |
| nAlarmLimitHigh           | DWORD  | 2#10000000000        | 高温警告    |
| nAlarmLimitHighHigh       | DWORD  | 2#100000000000       | 极高温警告   |
| nAlarmAbsoluteHigh        | DWORD  | 2#1000000000000      | 绝对高温警告  |
| nAlarmAbsoluteLow         | DWORD  | 2#10000000000000     | 绝对低温警告  |
| nAlarmSlopeMin            | DWORD  | 2#10000000000000000  | 最小斜率警告  |
| nAlarmSlopeMax            | DWORD  | 2#100010000000000000 | 最大斜率警告  |



**使用要求**

| 开发环境        | 目标平台 | 需要包含的**PLC 库**  |
| ----------- | ---- | --------------- |
| MetaFacture | PC   | ZKSDTempControl |


---
### 全局常量

| **名称**              | **类型** | **初始化** | **描述**                      |
| ------------------- | ------ | ------- | --------------------------- |
| RingBufferLen       | INT    | 10      | RingBuffer global variables |
| MAX\_LOGBUFFER\_LEN | INT    | 1000    | log data                    |

## 例程和库下载

此产品的示例代码和配置获取链接：<链接>\[待插入]。在那里，您可以选择克隆存储库或下载包含示例的ZlP文件。

存在以下示例：

| **名称**                           | **<产品>版本** | **描述**    |
| -------------------------------- | ---------- | --------- |
| --.project                       | --         | CODESYS例程 |
| ZKSDTempControl.compiled-library | V1.0.0.0   | 温度控制算法库   |
| ControlToolBox.compiled-library  | V1.1.3.0   | 控制工具库     |

**使用要求**

| 开发环境        | 目标平台 | 需要包含的**PLC 库**  |
| ----------- | ---- | --------------- |
| MetaFacture | PC   | ZKSDTempControl |